### 概览

Modbus 本身是一种信息交换的规范，Modbus Rtu 则是透过串口来实现 Modbus 的一种方式，因此所有的信息都是通过串口来传输；Modbus 协议属于 C/S 架构，Modbus Rtu Master 可以读写 Rtu Slave 的地址，实现数据交互；

**使用场景**

- 设备间数据采集和监控（如 PLC 与传感器、HMI 的连接）。

- 过程自动化中的数据传输。

- 远程监控和控制系统。

**整体架构**

![](https://resource.helplook.net/docker_production/3648ne/article/XzctfJDb/68009510c19eb.png)
注： 本手册中用到的中科时代的软件包，均可以从官网的子页面获取。官网提供的版本可能比本手册中提到的版本更高，一般情况下这不会影响您按照本手册的例子执行相应的操作

- Modbus Rtu 是透过串口来实现 Modbus 的一种方式，因此所有讯息是透过串口来传输的，Modbus Rtu Master 可以对 Rtu Slave 发送读或者写的指令，Rtu Slave 收到指令后会回复确认信息，整个 Modbus 的沟通建立在一来一回的讯息交换上；

- 下表概述了各个产品组件

| **产品组件**                        | **描述说明**                         |
| ----------------------------------- | ------------------------------------ |
| simodbusmaster_1.0.9_amd64.deb      | Modbus rtu Master RTE 组件           |
| SF4100_ModbusMaster_1.0.0.2.library | Modbus rtu Master Metafacture 库文件 |

---
### 安装卸载

**安装要求**

- 中科时代出厂的工智机；

- 熟悉基础的 Linux 操作命令

**安装过程**

**工智机端安装 Modbus Rtu Master RTE 组件**

- 上传 deb 包到工智机 Linux 环境的/home/sinsegye 目录下

- 上传完成后在工智机上执行命令安装（参考下方截图，如果模块文件名发生变化则命令行中的文件名做相应更改）

- 修改 RTE 的配置文件，ComponentManger 模块下加入 simodbusmaster

- 重启 RTE 服务，使新加入的 simodbusmaster 被调用

**Metafacture 安装 library**

- 打开 Metafacture，点击“工具” -- “库存储”
  ![](https://resource.helplook.net/docker_production/3648ne/article/XzctfJDb/6800952831948.png)

- 点击“安装” -- 选中 modbus master 的库文件，点击“打开”
<div align="center">
  <img src="https://resource.helplook.net/docker_production/3648ne/article/XzctfJDb/6800954f523a7.png" alt="description">
</div>


- 工程中点击“库管理器” -- “添加库” -- 选中 modbus 库点击“确定”
  ![](https://resource.helplook.net/docker_production/3648ne/article/XzctfJDb/6800953f8efe8.png)

**更新安装**

**工智机端升级 Modbus Rtu Master RTE 组件**

- 上传 deb 包到工智机 Linux 环境的/home/sinsegye 目录下

- 上传完成后在工智机上执行命令安装（参考下方截图，如果模块文件名发生变化则命令行中的文件名做相应更改）

- 重启 RTE 服务，使新升级的 simodbusmaster 生效

**Metafacture 升级 library**

- 打开 Metafacture，点击“工具” -- “库存储”
  ![](https://resource.helplook.net/docker_production/3648ne/article/XzctfJDb/680095468cb81.png)

- 点击“安装” -- 选中新的 modbus master 的库文件，点击“打开”

<div align="center">
  <img src="https://resource.helplook.net/docker_production/3648ne/article/XzctfJDb/6800954f523a7.png" alt="description">
</div>


- 工程中点击“库管理器” -- “添加库” -- 选中新的 modbus master 库点击“确定”
  ![](https://resource.helplook.net/docker_production/3648ne/article/XzctfJDb/68009554c93c5.png)

**卸载过程**

**工智机端卸载 Modbus Rtu Master RTE 组件**

- 工智机上执行命令卸载 modbusmaster

- 修改 RTE 的配置文件，ComponentManger 模块下去掉 simodbusmaster

- 重启 RTE 服务

**卸载 MetaFacture 侧的 Modbus Rtu master library**

- MetaFacture 界面点击“工具” -- “库存储”&#x20;
  ![](https://resource.helplook.net/docker_production/3648ne/article/XzctfJDb/6800955d220bd.png)

- 对话框中选中安装的 modbus master 的库，点击“卸载”
  ![](https://resource.helplook.net/docker_production/3648ne/article/XzctfJDb/6800956a91990.png)
---
### 技术说明

#### 快速启动

**本例软、硬件配置**

**硬件：**

1. SX5100 工智机 MetaOS V24.08.15_SX5

2. Win10 PC

**软件：**

1. MetaFacutre V1.0.6.3

2. Modbus slave 从站工具

**本例实验要求及原理**

- 实验要求：按照“安装卸载”部分中的“安装过程”配置完成 Modbus Rtu Master 环境

**实验原理**
![](https://resource.helplook.net/docker_production/3648ne/article/XzctfJDb/6800957534f25.png)

- Metafacture Modbus Rtu 站通过串口连接向第三方 Modbus Rtu 从站发送请求，主要包含：功能码、目标寄存器的地址和数量、写操作时的数据；从站收到请求后先检查数据的合法性，然后执行请求的操作，响应主站请求；

- 上位机和工智机使用 EtherNet 连接；

- 上位机上，MetaFacture 下装工程到工智机。工程中会包含下面的试验操作步骤中的配置；

- 工智机与第三方 TCPIP 客户端通过串口连接；

**本例实验操作步骤**

**主站初始化串口实验步骤如下**

- POU 中声明区域调用 modbus rtu master 初始化串口功能块

- POU 中程序区域调用 Fb_serialInit

**读多线圈的实验步骤如下：**

- POU 中声明区域调用 modbus rtu master 读多线圈功能块

- POU 中程序区域调用 Fb_readcoils

- 工程运行后触发 Fb_readCoils 中的 bExecute 上升沿执行读取线圈的值

**读取离散输入的实验步骤如下：**

- POU 中声明区域调用 modbus rtu master 读离散输入功能块

- POU 中程序区域调用 Fb_readInputs

- 工程运行后触发 Fb_readInputs 中的 bExecute 上升沿执行读取离散输入的值；

**读取保持寄存器的实验步骤如下：**

- POU 中声明区域调用 modbus rtu master 读保持寄存器功能块

- POU 中程序区域调用 Fb_readRegs

- 工程运行后触发 Fb_readRegs 中的 bExecute 上升沿执行读取保持寄存器的值；

**读取输入寄存器的实验步骤如下：**

- POU 中声明区域调用 modbus rtu master 读输入寄存器功能块

- POU 中程序区域调用 Fb_readInputRegs

- 工程运行后触发 Fb_readInputRegs 中的 bExecute 上升沿执行读取输入寄存器的值；

**写多线圈的实验步骤如下：**

- POU 中声明区域调用 modbus rtu master 写多线圈功能块

- POU 中程序区域调用 Fb_writeCoils

- 工程运行后触发 Fb_writecoils 中的 bExecute 上升沿执行写多线圈的值；

**写多保持寄存器的实验步骤如下：**

- POU 中声明区域调用 modbus rtu master 写多保持寄存器功能块

- POU 中程序区域调用 Fb_writeRegs

- 工程运行后触发 Fb_writeRegs 中的 bExecute 上升沿执行写多保持寄存器的值；

**写单线圈的实验步骤如下：**

- POU 中声明区域调用 modbus rtu master 写单个线圈功能块

- POU 中程序区域调用 Fb_writeSingleCoil

- 工程运行后触发 Fb_writeSingleCoil 中的 bExecute 上升沿执行写单个线圈；

**写单个保持寄存器的实验步骤如下：**

- POU 中声明区域调用 modbus rtu master 写单个保持寄存器功能块

- POU 中程序区域调用 Fb_writeSingleReg

- 工程运行后触发 Fb_writeSingleReg 中的 bExecute 上升沿执行写单个保持寄存器；

#### 实验注意点

1、实验中用到的从站 COM 口以实际为准；

2、实验中使用的从站案例如下：

- Modbus Slave 中的从站 COM 口及串口波特率等配置以实际为准：
  ![](https://resource.helplook.net/docker_production/3648ne/article/XzctfJDb/6800957ec7a69.png)

- 线圈配置 21 位
  ![](https://resource.helplook.net/docker_production/3648ne/article/XzctfJDb/680095870dc2f.png)

- 离散输入配置 10 位
  ![](https://resource.helplook.net/docker_production/3648ne/article/XzctfJDb/6800959290ce8.png)

- 保持寄存器配置 21 位
  ![](https://resource.helplook.net/docker_production/3648ne/article/XzctfJDb/68009598edaa7.png)

- 输入寄存器配置 10 位
  ![](https://resource.helplook.net/docker_production/3648ne/article/XzctfJDb/680095a0c27b1.png)


---
### 功能介绍
#### 主站配置初始化串口
**功能块 FB_MBRtuSerialPortInit 介绍**

![](https://resource.helplook.net/docker_production/3648ne/article/XzctfJDb/680095ae23948.png)

参数介绍

- 输入参数

| 参数名称 | 参数类型 | 描述                                                      |
| -------- | -------- | --------------------------------------------------------- |
| PortName | STRING   | 串口号                                                    |
| BaudRate | UINT     | 波特率设置，常用的波特率类型如 9600、38400、115200 均支持 |
| DataBits | UINT     | 数据位                                                    |
| StopBits | UINT     | 停止位                                                    |
| Parity   | STRING   | 校验位                                                    |
| Execute  | BOOL     | 触发执行                                                  |
| Timeout  | TIME     | 超时                                                      |

- 输出参数

| 参数名称 | 参数类型 | 描述                                                            |
| -------- | -------- | --------------------------------------------------------------- |
| BUSY     | BOOL     | 功能块激活时设置，直到确认接收                                  |
| Error    | BOOL     | 如果命令在传输过程中出现错误，则设置 true 直到 bBusy 输出被重置 |
| ErrorId  | UINT     | 当 bError 输出被设置，提供错误号                                |

#### 主站配置读取从站多线圈
**功能块 FB_MBRtuReadCoils 介绍**

![](https://resource.helplook.net/docker_production/3648ne/article/XzctfJDb/680095b57ede8.png)

参数介绍

- 输入参数

| 参数名称    | 参数类型        | 描述                     |
| ----------- | --------------- | ------------------------ |
| UnitID      | UINT            | 从站的 ID                |
| Quantity    | UINT            | 读取的线圈位数           |
| MBAddr      | WORD            | 读取的线圈起始位置       |
| cbLength    | UINT            | 存储读取的字节大小       |
| pMemoryAddr | POINTER TO BYTE | 要读的存放数据的存放地址 |
| Execute     | BOOL            | 触发读取动作             |
| tTimeout    | Time            | 超时                     |

- 输出参数

| 参数名称 | 参数类型 | 描述                                                            |
| -------- | -------- | --------------------------------------------------------------- |
| BUSY     | BOOL     | 功能块激活时设置，直到确认接收                                  |
| Error    | BOOL     | 如果命令在传输过程中出现错误，则设置 true 直到 bBusy 输出被重置 |
| ErrorId  | UINT     | 当 bError 输出被设置，提供错误号                                |

#### 主站配置读取从站输入寄存器

**功能块 FB_MBRtuReadInputRegs 介绍**

![](https://resource.helplook.net/docker_production/3648ne/article/XzctfJDb/680095bb9fcd5.png)

参数介绍

- 输入参数

| 参数名称    | 参数类型        | 描述                                      |
| ----------- | --------------- | ----------------------------------------- |
| UnitID      | UINT            | 从站的 ID                                 |
| Quantity    | UINT            | 读取的输入寄存器位数，一次最多读取 125 位 |
| MBAddr      | UINT            | 读取的输入寄存器起始位置                  |
| cbLength    | UINT            | 存储读取的字节大小                        |
| pMemoryAddr | POINTER TO BYTE | 要读的存放数据的存放地址                  |
| Execute     | BOOL            | 触发读取动作                              |
| tTimeout    | Time            | 超时                                      |

- 输出参数

| 参数名称 | 参数类型 | 描述                                                            |
| -------- | -------- | --------------------------------------------------------------- |
| BUSY     | BOOL     | 功能块激活时设置，直到确认接收                                  |
| Error    | BOOL     | 如果命令在传输过程中出现错误，则设置 true 直到 bBusy 输出被重置 |
| ErrorId  | UINT     | 当 bError 输出被设置，提供错误号                                |

#### 主站配置读取从站离散输入

**功能块 FB_MBRtuReadInputs 介绍**

![](https://resource.helplook.net/docker_production/3648ne/article/XzctfJDb/680095c2313bb.png)

参数介绍

- 输入参数

| 参数名称    | 参数类型        | 描述                     |
| ----------- | --------------- | ------------------------ |
| UnitID      | UINT            | 从站的 ID                |
| Quantity    | UINT            | 读取的离散输入位数       |
| MBAddr      | UINT            | 读取的离散输入起始位置   |
| cbLength    | UINT            | 存储读取的字节大小       |
| pMemoryAddr | POINTER TO BYTE | 要读的存放数据的存放地址 |
| Execute     | BOOL            | 触发读取动作             |
| tTimeout    | Time            | 超时                     |

- 输出参数

| 参数名称 | 参数类型 | 描述                                                            |
| -------- | -------- | --------------------------------------------------------------- |
| BUSY     | BOOL     | 功能块激活时设置，直到确认接收                                  |
| Error    | BOOL     | 如果命令在传输过程中出现错误，则设置 true 直到 bBusy 输出被重置 |
| ErrorId  | UINT     | 当 bError 输出被设置，提供错误号                                |

#### 主站配置读取从站保持寄存器
**功能块 FB_MBRtuReadRegs 介绍**

![](https://resource.helplook.net/docker_production/3648ne/article/XzctfJDb/680095c8cae93.png)

参数介绍

- 输入参数

| 参数名称    | 参数类型        | 描述                                      |
| ----------- | --------------- | ----------------------------------------- |
| UnitID      | UINT            | 从站的 ID                                 |
| Quantity    | UINT            | 读取的保持寄存器位数，一次最多读取 125 位 |
| MBAddr      | UINT            | 读取的保持寄存器起始位置                  |
| cbLength    | UINT            | 存储读取的字节大小                        |
| pMemoryAddr | POINTER TO BYTE | 要读的存放数据的存放地址                  |
| Execute     | BOOL            | 触发读取动作                              |
| tTimeout    | Time            | 超时                                      |

- 输出参数

| 参数名称 | 参数类型 | 描述                                                            |
| -------- | -------- | --------------------------------------------------------------- |
| BUSY     | BOOL     | 功能块激活时设置，直到确认接收                                  |
| Error    | BOOL     | 如果命令在传输过程中出现错误，则设置 true 直到 bBusy 输出被重置 |
| ErrorId  | UINT     | 当 bError 输出被设置，提供错误号                                |

#### 主站配置写从站多线圈
**功能块 FB_MBRtuWriteCoils 介绍**

![](https://resource.helplook.net/docker_production/3648ne/article/XzctfJDb/680095cf9e3a6.png)

参数介绍

- 输入参数

| 参数名称    | 参数类型        | 描述                 |
| ----------- | --------------- | -------------------- |
| UnitID      | UINT            | 从站的 ID            |
| Quantity    | WORD            | 要写入的线圈位数     |
| MBAddr      | WORD            | 要写入的线圈起始位置 |
| cbLength    | UINT            | 存储写入的字节大小   |
| pMemoryAddr | POINTER TO BYTE | 要写入的数据的地址   |
| Execute     | BOOL            | 触发写入动作         |
| tTimeout    | Time            | 超时                 |

- 输出参数

| 参数名称 | 参数类型 | 描述                                                            |
| -------- | -------- | --------------------------------------------------------------- |
| BUSY     | BOOL     | 功能块激活时设置，直到确认接收                                  |
| Error    | BOOL     | 如果命令在传输过程中出现错误，则设置 true 直到 bBusy 输出被重置 |
| ErrorId  | UINT     | 当 bError 输出被设置，提供错误号                                |

#### 主站配置写从站多保持寄存器
**功能块 FB_MBRtuWriteRegs 介绍**

![](https://resource.helplook.net/docker_production/3648ne/article/XzctfJDb/680095d5d6601.png)

参数介绍

- 输入参数

| 参数名称    | 参数类型        | 描述                         |
| ----------- | --------------- | ---------------------------- |
| UnitID      | UINT            | 从站的 ID                    |
| Quantity    | UINT            | 要写入的保持寄存器位数       |
| MBAddr      | UINT            | 要写入的保持寄存器的起始位置 |
| pMemoryAddr | POINTER TO WORD | 要写入的数据的地址           |
| Execute     | BOOL            | 触发写入动作                 |
| tTimeout    | Time            | 超时                         |

- 输出参数

| 参数名称 | 参数类型 | 描述                                                            |
| -------- | -------- | --------------------------------------------------------------- |
| BUSY     | BOOL     | 功能块激活时设置，直到确认接收                                  |
| Error    | BOOL     | 如果命令在传输过程中出现错误，则设置 true 直到 bBusy 输出被重置 |
| ErrorId  | UINT     | 当 bError 输出被设置，提供错误号                                |

#### 主站配置写从站单线圈
**功能块 FB_MBRtuWriteSingleCoil 介绍**
![](https://resource.helplook.net/docker_production/3648ne/article/XzctfJDb/680095dc9c24e.png)

参数介绍

- 输入参数

| 参数名称 | 参数类型 | 描述             |
| -------- | -------- | ---------------- |
| UnitID   | UINT     | 从站的 ID        |
| MBAddr   | WORD     | 要写入的线圈位置 |
| Value    | BOOL     | 要写入的线圈值   |
| Execute  | BOOL     | 触发写入动作     |
| tTimeout | Time     | 超时             |

- 输出参数

| 参数名称 | 参数类型 | 描述                                                            |
| -------- | -------- | --------------------------------------------------------------- |
| BUSY     | BOOL     | 功能块激活时设置，直到确认接收                                  |
| Error    | BOOL     | 如果命令在传输过程中出现错误，则设置 true 直到 bBusy 输出被重置 |
| ErrorId  | UINT     | 当 bError 输出被设置，提供错误号                                |

#### 主站配置写从站单保持寄存器
**功能块 FB_MBRtuWriteSingleReg 介绍**

![](https://resource.helplook.net/docker_production/3648ne/article/XzctfJDb/680095e8921c5.png)

参数介绍

- 输入参数

| 参数名称 | 参数类型 | 描述                   |
| -------- | -------- | ---------------------- |
| UnitID   | UINT     | 从站的 ID              |
| MBAddr   | WORD     | 要写入的保持寄存器位置 |
| Value    | WORD     | 要写入的保持寄存器值   |
| Execute  | BOOL     | 触发写入动作           |
| tTimeout | Time     | 超时                   |

- 输出参数

| 参数名称 | 参数类型 | 描述                                                            |
| -------- | -------- | --------------------------------------------------------------- |
| BUSY     | BOOL     | 功能块激活时设置，直到确认接收                                  |
| Error    | BOOL     | 如果命令在传输过程中出现错误，则设置 true 直到 bBusy 输出被重置 |
| ErrorId  | UINT     | 当 bError 输出被设置，提供错误号                                |

#### 主站配置连接 32 从站

- 使用模拟软件配置 32 个 RTU 从站（各个从站 ID 配置不一样），参考如下：
  ![](https://resource.helplook.net/docker_production/3648ne/article/XzctfJDb/680095f044d38.png)

- 主站工程中配置连接 32 个从站进行读写操作，测试读写正常

---
### 错误处理

1. 如果串口不通或者主站请求的从站地址不存在，工程运行后功能块的 Error 会置 True
   ![](https://resource.helplook.net/docker_production/3648ne/article/XzctfJDb/680095f70f5f7.png)

- 需要先确定串口通讯正常，然后确定主要要请求的从站地址都存在；